/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssValue;

public class CssLength
extends CssValue {
    public static final int type = 6;
    private Float value = defaultValue;
    private int unit;
    private static String[] units = new String[]{"mm", "cm", "pt", "pc", "em", "ex", "px", "in", "gd"};
    private static int[] hash_units;
    private static Float defaultValue;

    public final int getType() {
        return 6;
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        s = s.toLowerCase();
        int length = s.length();
        String unit = s.substring(length - 2, length);
        this.value = new Float(s.substring(0, length - 2));
        this.unit = 2;
        if (unit.equals("gd") && this.cssversion.equals("css2")) {
            throw new InvalidParamException("unit", unit, ac);
        }
        if (this.value.floatValue() != 0.0f) {
            int hash = unit.hashCode();
            for (int i = 0; i < units.length; ++i) {
                if (hash != hash_units[i]) continue;
                this.unit = i;
                return;
            }
        } else {
            return;
        }
        throw new InvalidParamException("unit", unit, ac);
    }

    public Object get() {
        return this.value;
    }

    public String getUnit() {
        return units[this.unit];
    }

    public String toString() {
        if (this.value.floatValue() != 0.0f) {
            return Util.displayFloat(this.value) + this.getUnit();
        }
        return Util.displayFloat(this.value);
    }

    public boolean equals(Object value) {
        return value instanceof CssLength && this.value.equals(((CssLength)value).value) && this.unit == ((CssLength)value).unit;
    }

    static {
        defaultValue = new Float(0.0f);
        hash_units = new int[units.length];
        for (int i = 0; i < units.length; ++i) {
            CssLength.hash_units[i] = units[i].hashCode();
        }
    }
}

